// Slider functionality
let currentSlide = 0
let slideInterval = null

function goToSlide(index) {
  const slides = document.querySelectorAll('.slide-brutal')
  const dots = document.querySelectorAll('.dot-brutal')
  const totalSlides = slides.length
  
  if (slides.length === 0) return
  
  slides[currentSlide].classList.remove('active')
  if (dots[currentSlide]) dots[currentSlide].classList.remove('active')
  
  currentSlide = index
  if (currentSlide >= totalSlides) currentSlide = 0
  if (currentSlide < 0) currentSlide = totalSlides - 1
  
  slides[currentSlide].classList.add('active')
  if (dots[currentSlide]) dots[currentSlide].classList.add('active')
}

function goToNext() {
  const slides = document.querySelectorAll('.slide-brutal')
  const totalSlides = slides.length
  goToSlide((currentSlide + 1) % totalSlides)
}

function goToPrevious() {
  const slides = document.querySelectorAll('.slide-brutal')
  const totalSlides = slides.length
  goToSlide((currentSlide - 1 + totalSlides) % totalSlides)
}

function initSlider() {
  const slides = document.querySelectorAll('.slide-brutal')
  if (slides.length > 0) {
    if (slideInterval) {
      clearInterval(slideInterval)
    }
    currentSlide = 0
    goToSlide(0)
    slideInterval = setInterval(() => {
      goToNext()
    }, 3000)
  }
}

// Applications page
function initIndexPage() {
  loadApplications()
  initSlider()
}

function loadApplications() {
  const saved = localStorage.getItem('courseApplications')
  let applications = []
  
  if (saved) {
    try {
      applications = JSON.parse(saved)
    } catch (e) {
      applications = []
    }
  } else {
    applications = [
      {
        id: 1,
        courseName: 'Основы алгоритмизации и программирования',
        startDate: '2025-05-15',
        status: 'active',
        review: null
      },
      {
        id: 2,
        courseName: 'Основы веб-дизайна',
        startDate: '2025-04-20',
        status: 'completed',
        review: {
          rating: 5,
          text: 'Отличный курс! Очень понравилась подача материала.'
        }
      },
      {
        id: 3,
        courseName: 'Основы проектирования баз данных',
        startDate: '2025-03-10',
        status: 'completed',
        review: null
      }
    ]
    localStorage.setItem('courseApplications', JSON.stringify(applications))
  }
  
  renderApplications(applications)
}

function renderApplications(applications) {
  const container = document.getElementById('applications-container')
  if (!container) return
  
  if (applications.length === 0) {
    container.innerHTML = `
      <div class="empty-state-brutal">
        <div class="empty-icon-wrapper-brutal">
          <img src="icons/file-text.svg" alt="File" width="64" height="64">
        </div>
        <h2 class="empty-title-brutal">Нет заявок</h2>
        <p class="empty-text-brutal">Создайте первую заявку на курс</p>
        <a href="enroll.html" class="empty-button-brutal">
          Записаться на курс
        </a>
      </div>
    `
    return
  }
  
  container.innerHTML = applications.map((application) => {
    const date = new Date(application.startDate).toLocaleDateString('ru-RU', { 
      day: 'numeric', 
      month: 'long', 
      year: 'numeric' 
    })
    
    const reviewSection = application.status === 'completed' 
      ? (application.review 
          ? `
            <div class="review-section-brutal">
              <div class="review-display-brutal">
                <div class="review-stars-brutal">
                  ${Array.from({ length: 5 }).map((_, i) => 
                    `<img src="icons/star.svg" alt="Star" width="20" height="20" style="filter: ${i < application.review.rating ? 'brightness(0) saturate(100%) invert(77%) sepia(95%) saturate(1352%) hue-rotate(358deg) brightness(101%) contrast(101%);' : 'opacity: 0.3;'}">`
                  ).join('')}
                </div>
                <p class="review-text-brutal">${application.review.text}</p>
              </div>
            </div>
          `
          : `
            <div class="review-section-brutal">
              <div class="review-form-brutal">
                <div class="review-header-brutal">
                  <img src="icons/message-square.svg" alt="Message" width="20" height="20">
                  <span>Оставить отзыв о качестве образовательных услуг</span>
                </div>
                <p class="review-hint-brutal">Оцените курс по 5-балльной шкале и поделитесь своими впечатлениями</p>
                <div class="rating-brutal">
                  <span class="rating-label-brutal">Рейтинг:</span>
                  ${Array.from({ length: 5 }).map((_, i) => 
                    `<button type="button" class="star-btn-brutal" onclick="setRating(${application.id}, ${i + 1})" title="Оценить на ${i + 1} ${i === 0 ? 'звезду' : i < 4 ? 'звезды' : 'звезд'}">
                      <img src="icons/star.svg" alt="Star" width="32" height="32" id="star-${application.id}-${i + 1}">
                    </button>`
                  ).join('')}
                  <span class="rating-value-brutal" id="rating-value-${application.id}" style="display: none;"></span>
                </div>
                <div class="textarea-wrapper-brutal">
                  <label for="review-text-${application.id}" class="textarea-label-brutal">Ваш отзыв:</label>
                  <textarea
                    id="review-text-${application.id}"
                    class="review-textarea-brutal"
                    placeholder="Расскажите о вашем опыте обучения, что понравилось, что можно улучшить..."
                    rows="4"
                  ></textarea>
                </div>
                <button
                  class="submit-review-brutal"
                  onclick="submitReview(${application.id})"
                  id="submit-review-${application.id}"
                >
                  Отправить отзыв
                </button>
              </div>
            </div>
          `
        )
      : `
        <div class="complete-section-brutal">
          <button
            class="complete-btn-brutal"
            onclick="completeCourse(${application.id})"
          >
            <img src="icons/check-circle.svg" alt="Check" width="20" height="20">
            <span>Завершить курс</span>
          </button>
        </div>
      `
    
    return `
      <div class="application-item-brutal ${application.status}">
        <div class="item-header-brutal">
          <div class="item-number-brutal">#${application.id}</div>
          <div class="status-indicator-brutal ${application.status}">
            ${application.status === 'active' 
              ? `<img src="icons/clock.svg" alt="Clock" width="16" height="16"><span>Активна</span>`
              : `<img src="icons/check-circle.svg" alt="Check" width="16" height="16"><span>Завершена</span>`
            }
          </div>
        </div>
        <h3 class="item-title-brutal">${application.courseName}</h3>
        <div class="item-meta-brutal">
          <img src="icons/calendar.svg" alt="Calendar" width="18" height="18">
          <span>${date}</span>
        </div>
        ${reviewSection}
      </div>
    `
  }).join('')
}

let reviewRatings = {}

function setRating(applicationId, rating) {
  reviewRatings[applicationId] = rating
  
  for (let i = 1; i <= 5; i++) {
    const star = document.getElementById(`star-${applicationId}-${i}`)
    if (star) {
      if (i <= rating) {
        star.style.filter = 'brightness(0) saturate(100%) invert(77%) sepia(95%) saturate(1352%) hue-rotate(358deg) brightness(101%) contrast(101%);'
        star.style.opacity = '1'
      } else {
        star.style.filter = 'opacity(0.3)'
        star.style.opacity = '0.3'
      }
    }
  }
  
  const ratingValue = document.getElementById(`rating-value-${applicationId}`)
  if (ratingValue) {
    ratingValue.textContent = `${rating} из 5`
    ratingValue.style.display = 'inline'
  }
}

function submitReview(applicationId) {
  const rating = reviewRatings[applicationId]
  const textarea = document.getElementById(`review-text-${applicationId}`)
  const text = textarea ? textarea.value.trim() : ''
  
  if (!rating || !text) {
    alert('Пожалуйста, выберите рейтинг и напишите отзыв')
    return
  }
  
  const saved = localStorage.getItem('courseApplications')
  let applications = []
  
  if (saved) {
    try {
      applications = JSON.parse(saved)
    } catch (e) {
      applications = []
    }
  }
  
  const updated = applications.map(app => {
    if (app.id === applicationId) {
      return {
        ...app,
        review: {
          rating: rating,
          text: text
        }
      }
    }
    return app
  })
  
  localStorage.setItem('courseApplications', JSON.stringify(updated))
  loadApplications()
}

function completeCourse(applicationId) {
  const saved = localStorage.getItem('courseApplications')
  let applications = []
  
  if (saved) {
    try {
      applications = JSON.parse(saved)
    } catch (e) {
      applications = []
    }
  }
  
  const updated = applications.map(app => {
    if (app.id === applicationId) {
      return {
        ...app,
        status: 'completed'
      }
    }
    return app
  })
  
  localStorage.setItem('courseApplications', JSON.stringify(updated))
  loadApplications()
}

// Enroll page
function initEnrollPage() {
  renderCourses()
  setupForm()
  initSlider()
}

const courses = [
  { 
    id: 'algorithms', 
    name: 'Основы алгоритмизации и программирования', 
    icon: 'code.svg',
    color: '#2563EB',
    description: 'Изучите основы программирования, алгоритмы и структуры данных. Начните свой путь в IT с нуля.',
    duration: '120 часов',
    level: 'Начальный',
    students: '2500+',
    rating: '4.9'
  },
  { 
    id: 'web-design', 
    name: 'Основы веб-дизайна', 
    icon: 'palette.svg',
    color: '#7C3AED',
    description: 'Создавайте красивые и функциональные веб-интерфейсы. Изучите UI/UX дизайн и современные инструменты.',
    duration: '100 часов',
    level: 'Начальный',
    students: '1800+',
    rating: '4.8'
  },
  { 
    id: 'databases', 
    name: 'Основы проектирования баз данных', 
    icon: 'database.svg',
    color: '#10B981',
    description: 'Освойте проектирование и работу с базами данных. SQL, нормализация, оптимизация запросов.',
    duration: '140 часов',
    level: 'Средний',
    students: '1200+',
    rating: '4.9'
  }
]

let selectedCourse = ''

function renderCourses() {
  const container = document.getElementById('courses-container')
  if (!container) return
  
  container.innerHTML = courses.map((course) => {
    return `
      <button
        type="button"
        class="course-card-brutal"
        data-course="${course.id}"
        onclick="selectCourse('${course.id}')"
      >
        <div class="course-card-header-brutal">
          <div class="course-icon-brutal" style="background: ${course.color}15; color: ${course.color};">
            <img src="icons/${course.icon}" alt="${course.name}" width="32" height="32">
          </div>
        </div>
        <h3 class="course-name-brutal">${course.name}</h3>
        <p class="course-desc-brutal">${course.description}</p>
        <div class="course-stats-brutal">
          <div class="course-stat-brutal">
            <img src="icons/clock.svg" alt="Clock" width="16" height="16">
            <span>${course.duration}</span>
          </div>
          <div class="course-stat-brutal">
            <img src="icons/users.svg" alt="Users" width="16" height="16">
            <span>${course.students}</span>
          </div>
          <div class="course-stat-brutal">
            <img src="icons/award.svg" alt="Award" width="16" height="16">
            <span>${course.rating}</span>
          </div>
        </div>
        <div class="course-level-brutal">
          <span>${course.level}</span>
        </div>
      </button>
    `
  }).join('')
}

function selectCourse(courseId) {
  selectedCourse = courseId
  
  document.querySelectorAll('.course-card-brutal').forEach(btn => {
    btn.classList.remove('selected')
    if (btn.dataset.course === courseId) {
      btn.classList.add('selected')
    }
  })
  
  const dateSection = document.getElementById('date-section')
  if (dateSection) {
    dateSection.style.display = 'block'
  }
  
  updateSubmitButton()
}

function setupForm() {
  const today = new Date()
  const maxDate = new Date(today.getTime() + 90 * 24 * 60 * 60 * 1000)
  const minDateStr = today.toISOString().split('T')[0]
  const maxDateStr = maxDate.toISOString().split('T')[0]
  
  const dateInput = document.getElementById('date-input')
  if (dateInput) {
    dateInput.min = minDateStr
    dateInput.max = maxDateStr
    dateInput.addEventListener('change', () => {
      updateSubmitButton()
    })
  }
  
  const form = document.getElementById('enroll-form')
  if (form) {
    form.addEventListener('submit', handleSubmit)
  }
}

function updateSubmitButton() {
  const dateInput = document.getElementById('date-input')
  const submitBtn = document.getElementById('submit-btn')
  
  if (submitBtn && dateInput) {
    submitBtn.disabled = !selectedCourse || !dateInput.value
  }
}

function handleSubmit(e) {
  e.preventDefault()
  
  if (!selectedCourse) {
    alert('Пожалуйста, выберите курс')
    return
  }
  
  const dateInput = document.getElementById('date-input')
  if (!dateInput || !dateInput.value) {
    alert('Пожалуйста, выберите дату')
    return
  }
  
  const saved = localStorage.getItem('courseApplications')
  const applications = saved ? JSON.parse(saved) : []
  
  const courseData = courses.find(c => c.id === selectedCourse)
  
  const newApplication = {
    id: Date.now(),
    courseName: courseData.name,
    startDate: dateInput.value,
    status: 'active',
    review: null
  }
  
  applications.push(newApplication)
  localStorage.setItem('courseApplications', JSON.stringify(applications))
  
  const successMsg = document.getElementById('success-message')
  if (successMsg) {
    successMsg.style.display = 'flex'
  }
  
  setTimeout(() => {
    window.location.href = 'index.html'
  }, 2000)
}

// Initialize page
function initPage() {
  if (window.location.pathname.includes('enroll.html')) {
    initEnrollPage()
  } else {
    initIndexPage()
  }
}

// Run on page load
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initPage)
} else {
  initPage()
}

